Public Class Car
    ' Le type imbriqu dans la classe Car.
    Public Class Radio
        Public Sub TurnOn(ByVal state As Boolean)
            If (state) Then
                Console.WriteLine("Diffusion en cours...")
            Else
                Console.WriteLine("Autoradio au repos...")
            End If
        End Sub
    End Class

    ' Cette voiture peut mettre ces vnements.
    Public Event Exploded(ByVal msg As String)
    Public Event AboutToBlow(ByVal msg As String)

    ' Donnes d'tat internes.
    Private currSpeed As Integer
    Private maxSpeed As Integer
    Private petName As String

    ' La voiture est-elle en tat de marche ou hors-service ? 
    Private isDead As Boolean

    ' NOUVEAU !  A-t-on besoin d'un nettoyage ?
    Private isDirty As Boolean

    ' NOUVEAU!  Faut-il changer les pneus ?
    Private shouldRotate As Boolean

    ' Une voiture est quipe d'un auto-radio.
    Private theMusicBox As Radio

    Public Property Dirty() As Boolean
        Get
            Return isDirty
        End Get
        Set(ByVal Value As Boolean)
            isDirty = Value
        End Set
    End Property

    Public Property Rotate() As Boolean
        Get
            Return shouldRotate
        End Get
        Set(ByVal Value As Boolean)
            shouldRotate = Value
        End Set
    End Property

    Public Sub New()
        maxSpeed = 100
        isDead = False
        theMusicBox = New Radio()
    End Sub
    Public Sub New(ByVal name As String, ByVal max As Integer, ByVal curr As Integer)
        currSpeed = curr
        maxSpeed = max
        petName = name
        isDead = False
        isDirty = Dirty
        shouldRotate = Rotate
        theMusicBox = New Radio()
    End Sub

    Public Sub CrankTunes(ByVal state As Boolean)
        ' Demande le dmarrage de la radio (ou l'arrt).
        ' Dlgue la requte  l'objet interne.
        theMusicBox.TurnOn(state)
    End Sub

    Public Sub SpeedUp(ByVal delta As Integer)
        ' Si la voiture est hors-service, on l'indique...
        If (isDead) Then
            RaiseEvent Exploded("Dsol, la voiture est hors-service...")
        Else
            currSpeed += delta

            ' Presque hors-service?
            If (10 = maxSpeed - currSpeed) Then
                RaiseEvent AboutToBlow("Attention, vitesse maximale proche !")
            End If

            ' Toujours OK!
            If (currSpeed >= maxSpeed) Then
                isDead = True
            Else
                Console.WriteLine("--> Vitesse actuelle = {0}", currSpeed)
            End If
        End If
    End Sub
End Class

